﻿/*
* File Name: Script Js
* Author Name: arrowthemes
* Author URL: http://themeforest.net/user/arrowthemes/portfolio/?ref=arrowthemes
* Version: 1.0 */

(function($){

	$(document).on('ready', function() {
		
		// style the zoo blog buttons
		$('p.links').each(function() {
		    var $this = $(this);
		    $this.children().eq(0).addClass("button-color");
		    $this.children().eq(1).addClass("button");
		});		


		// style the zoo teaser image
		$('.element-image img, .zoo-item-list img').each(function() {
		    var $this = $(this);
		    $this.addClass("pic3d");
		});


		// zoo blog tags
		$('.element-itemtag a, .zoo-tagcloud a').each(function(i, elem) {
		    var $this = $(this);
		    var html = $(elem).html();
		    var final = '<span class="tag">' + html + '</span>';
		    $(this).html(final );
		    $this.addClass("tag-body yellow");	   
		});


		//block-number
		$('.block-number').each(function(i, elem){
		    var html = $(elem).html();
		    var final = '<span class="digit">' + html + '</span>';
		    $(this).html(final );
		});

		//event date/time block
		$('.event-time').each(function(i, elem){
		    var html = $(elem).html();
		    var dt =  html.split(":");
		    var final = '<span class="month">' + dt[1] + '</span><span class="date">' + dt[0] + '</span>';
		    $(this).html(final );
		    $(this).parent().addClass('event');
		});
		

		//social links hover effect 
		$('.top-links a').hover(function() {
			$(this).stop(true,true).animate({opacity: 0.5});
			},function() {
			$(this).stop(true,true).animate({opacity: 1});
		});

		//back to top
		if ($("#totop-scroller").length) {
			$().UItoTop({scrollSpeed: 500, easingType: 'easeOutExpo' });
		}

		// titles
		$('#contact-form, form.submission').prev().addClass('module-title');
		
		//li span
		$('.sheet-body ul.style li').each(function(i, elem){
		    var html = $(elem).html();
		    var final = '<span>' + html + '</span>';
		    $(this).html(final );
		});

		// remove empty p tags
		$('p').each(function() {
		    var $this = $(this);
		    if($this.html().replace(/\s|&nbsp;/g, '').length === 0)
		        $this.remove();
		});

		// image auto size exceptions
		$('img').addClass('size-auto');
		$('.mejs-poster img, .slide-image, img.no-size-auto, img.kstats-bar, img.pic-border.caption, .jr-forum-stat-bar').removeClass('size-auto');
		
		// apply reveal sizes
		$('.module.size-medium').each(function() {
		    $(this).closest('.reveal-modal').addClass('medium');
		});			
		$('.module.size-small').each(function() {
		    $(this).closest('.reveal-modal').addClass('small');
		});	
		$('.module.size-large').each(function() {
		    $(this).closest('.reveal-modal').addClass('large');
		});	
		$('.module.size-xlarge').each(function() {
		    $(this).closest('.reveal-modal').addClass('xlarge');
		});	
		

		// badges
		$('.badge.badge-new').parent().addClass('badge-new');
		$('.badge.badge-hot').parent().addClass('badge-hot');
		$('.badge.badge-free').parent().addClass('badge-free');
		$('.badge.badge-top').parent().addClass('badge-top');

		// toggles
		if ($('.showhide li').length > 0) {
			var showhide = $('.showhide li');
				showhide.each(function () {
				var q = $(this);

				if (q.children('section').css('display') === 'block') {
				q.children('h4').addClass('collapse');
				} else if (q.children('section').css('display') === 'none') {
				q.children('h4').addClass('expanded');
				}

				q.children('h4').click(function () {
				q.children('section').slideToggle('normal', function () {
				if (q.children('section').css('display') === 'block') {
				q.children('h4').addClass('collapse');
				q.children('h4').removeClass('expanded');

				} else if (q.children('section').css('display') === 'none') {
				q.children('h4').addClass('expanded');
				q.children('h4').removeClass('collapse');
				}

				});
			});
			});
		}
	});


})(jQuery);


// css helper
(function($) {
    var data = [
        {str:navigator.userAgent,sub:'Chrome',ver:'Chrome',name:'chrome'},
        {str:navigator.vendor,sub:'Apple',ver:'Version',name:'safari'},
        {prop:window.opera,ver:'Opera',name:'opera'},
        {str:navigator.userAgent,sub:'Firefox',ver:'Firefox',name:'firefox'},
        {str:navigator.userAgent,sub:'MSIE',ver:'MSIE',name:'ie'}];
    for (var n=0;n<data.length;n++)	{
        if ((data[n].str && (data[n].str.indexOf(data[n].sub) != -1)) || data[n].prop) {
            var v = function(s){var i=s.indexOf(data[n].ver);return (i!=-1)?parseInt(s.substring(i+data[n].ver.length+1)):'';};
            $('html').addClass(data[n].name+' '+data[n].name+v(navigator.userAgent) || v(navigator.appVersion)); break;			
        }
    }
})(jQuery);


/*UITop jquery*/
(function(a){a.fn.UItoTop=function(b){var c={text:"To Top",min:200,inDelay:600,outDelay:400,containerID:"toTop",containerHoverID:"toTopHover",scrollSpeed:1e3,easingType:"linear"};var d=a.extend(c,b);var e="#"+d.containerID;var f="#"+d.containerHoverID;a("body").append('<a href="#" title="" id="'+d.containerID+'">'+d.text+"</a>");a(e).hide().click(function(){a("html, body").animate({scrollTop:0},d.scrollSpeed,d.easingType);a("#"+d.containerHoverID,this).stop().animate({opacity:0},d.inDelay,d.easingType);return false}).prepend('<span id="'+d.containerHoverID+'"></span>').hover(function(){a(f,this).stop().animate({opacity:1},600,"linear")},function(){a(f,this).stop().animate({opacity:0},700,"linear")});a(window).scroll(function(){var b=a(window).scrollTop();if(typeof document.body.style.maxHeight==="undefined"){a(e).css({position:"absolute",top:a(window).scrollTop()+a(window).height()-50})}if(b>d.min)a(e).fadeIn(d.inDelay);else a(e).fadeOut(d.Outdelay)})}})(jQuery);

/*
 * jQuery Reveal Plugin 1.0
 * www.ZURB.com
 * Copyright 2010, ZURB
 * Free to use under the MIT license.
 * http://www.opensource.org/licenses/mit-license.php
*/
/*globals jQuery */

(function ($) {
  $('a[data-reveal-id]').live('click', function (event) {
    event.preventDefault();
    var modalLocation = $(this).attr('data-reveal-id');
    $('#' + modalLocation).reveal($(this).data());
  });

  $.fn.reveal = function (options) {
    var defaults = {
      animation: 'fadeAndPop',                // fade, fadeAndPop, none
      animationSpeed: 300,                    // how fast animtions are
      closeOnBackgroundClick: true,           // if you click background will modal close?
      dismissModalClass: 'close-reveal-modal', // the class of a button or element that will close an open modal
      open: $.noop,
      opened: $.noop,
      close: $.noop,
      closed: $.noop
    };
    options = $.extend({}, defaults, options);

    return this.each(function () {
      var modal    = $(this),
        topMeasure = parseInt(modal.css('top'), 10),
        topOffset  = modal.height() + topMeasure,
        locked     = false,
        modalBg    = $('.reveal-modal-bg'),
        closeButton;

      if (modalBg.length === 0) {
        modalBg = $('<div class="reveal-modal-bg" />').insertAfter(modal);
        modalBg.fadeTo('fast', 0.8);
      }
      
      function unlockModal() {
        locked = false;
      }

      function lockModal() {
        locked = true;
      }

      function openAnimation() {
        if (!locked) {
          lockModal();
          if (options.animation === "fadeAndPop") {
            modal.css({'top': $(document).scrollTop() - topOffset, 'opacity': 0, 'visibility': 'visible'});
            modalBg.fadeIn(options.animationSpeed / 2);
            modal.delay(options.animationSpeed / 2).animate({
              "top": $(document).scrollTop() + topMeasure + 'px',
              "opacity": 1
            }, options.animationSpeed, function () {
              modal.trigger('reveal:opened');
            });

          }
          if (options.animation === "fade") {
            modal.css({'opacity': 0, 'visibility': 'visible', 'top': $(document).scrollTop() + topMeasure});
            modalBg.fadeIn(options.animationSpeed / 2);
            modal.delay(options.animationSpeed / 2).animate({
              "opacity": 1
            }, options.animationSpeed, function () {
              modal.trigger('reveal:opened');
            });

          }
          if (options.animation === "none") {
            modal.css({'visibility': 'visible', 'top': $(document).scrollTop() + topMeasure});
            modalBg.css({"display": "block"});
            modal.trigger('reveal:opened');
          }
        }
      }
      modal.bind('reveal:open.reveal', openAnimation);

      function closeAnimation() {
        if (!locked) {
          lockModal();
          if (options.animation === "fadeAndPop") {
            modal.animate({
              "top":  $(document).scrollTop() - topOffset + 'px',
              "opacity": 0
            }, options.animationSpeed / 2, function () {
              modal.css({'top': topMeasure, 'opacity': 1, 'visibility': 'hidden'});
            });
            modalBg.delay(options.animationSpeed).fadeOut(options.animationSpeed, function () {
              modal.trigger('reveal:closed');
            });
          }
          if (options.animation === "fade") {
            modal.animate({
              "opacity" : 0
            }, options.animationSpeed, function () {
              modal.css({'opacity': 1, 'visibility': 'hidden', 'top': topMeasure});
            });
            modalBg.delay(options.animationSpeed).fadeOut(options.animationSpeed, function () {
              modal.trigger('reveal:closed');
            });
          }
          if (options.animation === "none") {
            modal.css({'visibility': 'hidden', 'top': topMeasure});
            modalBg.css({'display': 'none'});
            modal.trigger('reveal:closed');
          }
        }
      }

      function destroy() {
        modal.unbind('.reveal');
        modalBg.unbind('.reveal');
        $('.' + options.dismissModalClass).unbind('.reveal');
        $('body').unbind('.reveal');
      }

      modal.bind('reveal:close.reveal', closeAnimation);
      modal.bind('reveal:opened.reveal reveal:closed.reveal', unlockModal);
      modal.bind('reveal:closed.reveal', destroy);
      
      modal.bind('reveal:open.reveal', options.open);
      modal.bind('reveal:opened.reveal', options.opened);
      modal.bind('reveal:close.reveal', options.close);
      modal.bind('reveal:closed.reveal', options.closed);
      
      modal.trigger('reveal:open');

      closeButton = $('.' + options.dismissModalClass).bind('click.reveal', function () {
        modal.trigger('reveal:close');
      });

      if (options.closeOnBackgroundClick) {
        modalBg.css({"cursor": "pointer"});
        modalBg.bind('click.reveal', function () {
          modal.trigger('reveal:close');
        });
      }

      $('body').bind('keyup.reveal', function (event) {
        if (event.which === 27) { // 27 is the keycode for the Escape key
          modal.trigger('reveal:close');
        }
      });
    });
  };
} (jQuery));