var JATypo = new Class ({
	initialize: function(options) {
		this.options = $extend({
			offsets: {x:10, y: 10}
		}, options || {});
		
		this.overlay = new Element ('div', {'id':'jatypo-overlay'}).inject ($(document.body));
		this.overlay.setStyles ({'width':window.getScrollWidth(), 'height': window.getScrollHeight()});
		this.wrapper = $('jatypo-wrap');		
		if (!this.wrapper) return;		
		this.button = new Element ('div', {'class':'button2-left'}).adopt(new Element ('div', {'class':'button2-right jatypo-btn'}).setHTML('<span>JATypo</span>')).inject ($('editor-xtd-buttons'));
		this.typos = this.wrapper.getElements ('.typo');
		this.typos.addEvents ({
			'mouseenter': function (){
				this.addClass ('typo-over');
				//detect popup position
				var wrapper = $('jatypo-wrap');
				var sample = this.getElement ('.sample');
				var pos_s = findPos (sample);
				var pos_w = findPos (wrapper);
				var scroll_w = {x: wrapper.scrollLeft, y: wrapper.scrollTop};
				
				var x0 = pos_w.x + scroll_w.x;
				var y0 = pos_w.y + scroll_w.y;
				var w0 = wrapper.offsetWidth;
				var h0 = wrapper.offsetHeight;
				var x1 = pos_s.x;
				var y1 = pos_s.y;
				var w1 = sample.offsetWidth;
				var h1 = sample.offsetHeight;
				
				//Detect class need to add to ajdust the position of sample popup
				if (y1<y0) {this.addClass ('typo-top').removeClass ('typo-bottom')}
				if (y1+h1>y0+h0) {this.addClass ('typo-bottom').removeClass ('typo-top')}
				if (x1<x0) {this.addClass ('typo-left').removeClass ('typo-right')}
				if (x1+w1>x0+w0) {this.addClass ('typo-right').removeClass ('typo-left')}
				
			},
			'mouseleave': function (){this.removeClass ('typo-over');},
			'click': function (){
				var sample = this.getElement ('.sample');
				var html = sample.innerHTML;
				if ($('content')) {
					jInsertEditorText(html, 'content');
				}
				else {
					jInsertEditorText(html, 'text');	
				}
				$('jatypo-wrap').setStyle ('display', 'none');
			}
		});
		this.wrapper.remove().injectAfter (this.overlay);
		this.button.addEvent ('click', function (event) {
			event = new Event(event);
			//this.locate (event);
			this.position();
			event.stop();
		}.bind (this));
		this.overlay.addEvent ('click', function () {this.wrapper.setStyle ('display', 'none');this.overlay.setStyle ('display', 'none');}.bind(this));
		
		//Typo css into editor (tinymce)
		var doc = $('text_ifr')?($('text_ifr').contentWindow?$('text_ifr').contentWindow.document:$('text_ifr').contentDocument):null;
		if (doc) {
			var head = doc.getElementsByTagName('head')[0];
			var css = doc.createElement ('link');
			css.rel = 'stylesheet';
			css.type = 'text/css';
			css.href = this.options.typocss;
			head.appendChild (css);		
		}		
	},
	
	locate: function(event){
		var win = {'x': window.getWidth(), 'y': window.getHeight()};
		var scroll = {'x': window.getScrollLeft(), 'y': window.getScrollTop()};
		var pwin = {'x': this.wrapper.offsetWidth, 'y': this.wrapper.offsetHeight};
		var prop = {'x': 'left', 'y': 'top'};
		for (var z in prop){
			var pos = event.page[z] + this.options.offsets[z];
			if ((pos + pwin[z] - scroll[z]) > win[z]) pos = event.page[z] - this.options.offsets[z] - pwin[z];
			this.wrapper.setStyle(prop[z], pos);
		};
		
		this.wrapper.setStyle ('display', 'block');
		this.overlay.setStyle ('display', 'block');
	}, 
	
	position: function () {
		this.wrapper.setStyle ('display', 'block');
		this.overlay.setStyle ('display', 'block');
		var pos = this.button.getPosition();
		var scroll = {'x': window.getScrollLeft(), 'y': window.getScrollTop()};
		var pwin = {'x': this.wrapper.offsetWidth, 'y': this.wrapper.offsetHeight};
		this.wrapper.setStyles({
			'left': pos.x + this.options.offsets.x,
			'top': pos.y + this.options.offsets.y - pwin.y
		});
	}
	
});

function findPos (obj) {
	var curleft = curtop = 0;
	if (obj.offsetParent) {
		do {
			curleft += obj.offsetLeft;
			curtop += obj.offsetTop;
		} while (obj = obj.offsetParent);
	}

	return {x:curleft,y:curtop};
}
